#ifndef _TITLE_
#define _TITLE_
typedef struct MenuScreenItem MenuScreenItem;
typedef struct MenuScreen MenuScreen;
#include "common.h"
#include "main.h"
struct MenuScreenItem {
    str text;
    LandArray * alternates;
    int choice;
    MenuScreen * target;
    bool disabled;
    bool selected;
    int pos;
    int x, y, w, h;
};
struct MenuScreen {
    LandArray * items;
    str name;
    MenuScreen * parent;
    int x, y, w, h;
};
extern bool finding_input;
extern int finding_control;
MenuScreen* menu_screen_new(void);
MenuScreenItem* menu_screen_add(MenuScreen * self, str text);
MenuScreenItem* menu_item_at(int x, int y);
bool menu_is(str x);
MenuScreenItem* menu_item_get(void);
bool menu_item_is(str x);
void menu_screen_back(void);
void menu_goto(str x);
void menu_goup(void);
void menu_select_next(int d);
void menu_sideways(int d);
void menu_click(float x);
void title_init(void);
void title_com(int com);
void title_tick(void);
void menu_screen_draw(void);
float align(float x, float s);
void title_render(void);
#endif
